﻿using Syncfusion.Presentation;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Media.Media3D;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace SyncFusionPPTRepro1
{
    /// <summary>
    /// This is a simple WPF single-window app with a single button.
    /// Clicking the button generates the file "Test Deck <HH:mm:ss>.pptx" in the user's Documents folder.
    /// It contains one slide with one chart with 1 series and 3 data points.
    /// The middle datapoint has a custom color as expected, and the data label on the outside of the bar as expected,
    /// but the data label is formatted as a decimal and not as a % as specified and expected.
    /// 
    /// It appears that the act of accessing DataLabels on the data point creates a blank DataLabel object which
    /// does not copy from the one off DefaultDataPoint and the NumberFormat property is NOT saved.
    /// This is confirmed by inspecting the XML in the chart components of the Open XML, 
    /// where a numFmt element is not present in the created dLbl element in the chart part for the deck's single slide.
    /// Adding in the missing <numFmt> element, makes it work, so it appears that SyncFusion is not writing it out.
    /// </summary>


    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
        }

        private void Button_Click(object sender, RoutedEventArgs e)
        {
            using (var pptxDoc = Syncfusion.Presentation.Presentation.Create())
            {
                var slide = pptxDoc.Slides.Add();
                AddChart(slide);

                var docsPath = Environment.GetFolderPath(Environment.SpecialFolder.MyDocuments);
                var nowStr = DateTime.Now.ToString("HHmmss");
                var deckPath = System.IO.Path.Combine(docsPath, $"Test Deck {nowStr}.pptx");

                pptxDoc.Save(deckPath);
            }
        }

        private static void AddChart(ISlide slide)
        {
            double left = slide.SlideSize.Width * 0.1;
            double top = slide.SlideSize.Height * 0.1;
            double width = slide.SlideSize.Width * 0.8;
            double height = slide.SlideSize.Height * 0.8;
            
            var chart = slide.Charts.AddChart(left, top, width, height);
            chart.ChartType = Syncfusion.OfficeChart.OfficeChartType.Column_Clustered;
            if (chart.Series.Count < 1)
                chart.Series.Add();

            chart.DataRange = chart.ChartData[1, 1, 1+3, 1+1];

            chart.Series[0].DataPoints.DefaultDataPoint.DataLabels.IsValue = true;
            chart.Series[0].DataPoints.DefaultDataPoint.DataLabels.Position = Syncfusion.OfficeChart.OfficeDataLabelPosition.Inside;
            chart.Series[0].DataPoints.DefaultDataPoint.DataLabels.NumberFormat = "0%";

            chart.ChartData.SetValue(1 + 0, 1 + 1, "My Series");
            chart.ChartData.SetValue(1 + 1, 1 + 0, "A");
            chart.ChartData.SetValue(1 + 1, 1 + 1, 0.4);
            chart.ChartData.SetValue(1 + 2, 1 + 0, "B");
            chart.ChartData.SetValue(1 + 2, 1 + 1, 0.7);
            chart.ChartData.SetValue(1 + 3, 1 + 0, "C");
            chart.ChartData.SetValue(1 + 3, 1 + 1, 0.3);

            chart.Series[0].DataPoints[1].DataFormat.Fill.ForeColor = System.Drawing.Color.FromArgb(255, 255, 0, 0);

            // If the following lines are commented out, we don't get the label outside of the bar as expected
            // but the label uses the desired % format.
            // So accessing chart.Series[0].DataPoints[1].DataLabels causes a blank DataLabels object to be created
            // and saved with an index into the Open XML as a <dLbl> element
            // but the NumberFormat property is not saved as a necessary <numFmt> element.
            chart.Series[0].DataPoints[1].DataLabels.IsValue = true;
            chart.Series[0].DataPoints[1].DataLabels.Position = Syncfusion.OfficeChart.OfficeDataLabelPosition.Outside;
            chart.Series[0].DataPoints[1].DataLabels.NumberFormat = "0%";
        }
    }
}
